;;; -*- mode: lisp -*-
(in-package :cl-user)

#+sbcl(require :asdf)

(defpackage #:grobner-system
  (:use #:asdf #:cl))

(in-package #:grobner-system)

(defsystem grobner
    :author "Marek Rychlik"
    :licence "LLGPL"
    :components ((:file "grobner")
		 (:file "monomial")
                 (:file "term")
                 (:file "termlist")
                 (:file "polynomial")
                 (:file "order")
                 (:file "order-mk")
                 (:file "priority-queue")
                 (:file "pair-queue")
		 (:file "utilis")
		 (:file "division")
		 (:file "buchberger")
		 (:file "gebauer-moeller")
		 (:file "gb-postprocessing")
		 (:file "ideal")
		 (:file "mx-parsing")
		 )

    :perform     (load-op :after (op grobner)
			  (pushnew :grobner cl:*features*))

    )
