;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "TERM"
  (:use :cl :monomial :ring)
  (:export "TERM"
	   "TERM-COEFF"
	   "MAKE-TERM"
	   "MAKE-TERM-VARIABLE"
	   "TERM-MUL"
	   "TERM-SUGAR"))


(in-package :term)

(defstruct (term
	     (:include monom)
	     ;; BOA constructor. TODO: avoid code duplication with MONOM?
	     (:constructor make-term (dimension
				      &key 
				      (initial-exponents #() initial-exponents-supplied-p)
				      (initial-exponent  #() initial-exponent-supplied-p)
				      (exponents (cond 
						   ;; when exponents are supplied
						   (initial-exponents-supplied-p
						    (make-array (list dimension) :initial-contents initial-exponents
								:element-type 'exponent))
						   ;; when all exponents are to be identical
						   (initial-exponent-supplied-p
						    (make-array (list dimension) :initial-element initial-exponent
								:element-type 'exponent))
						   ;; otherwise, all exponents are zero
						   (t (make-array (list dimension) :element-type 'exponent :initial-element 0))))
				      coeff))
	     ;;(:constructor make-term-variable)
	     ;;(:type list)
	     )
  (coeff nil))


(defun make-term-variable (ring nvars pos
				&optional
				(power 1)
				(coeff (funcall (ring-unit ring))))
  "Construct a term in the polynomial ring RING[X[0],X[1],X[2],...X[NVARS-1]]
over the ring RING which represents a single variable. It assumes
number of variables NVARS and the variable is at position
POS. Optionally, the variable may appear raised to power POWER.
Optionally, the term may appear with an arbitrary coefficient, which
defaults to the unit of the RING."
  (declare (fixnum nvars pos power))
  (let ((result (make-term nvars)))
    (setf (monom-elt result pos) power)
    result))

(defun term-mul (ring term1 term2)
  "Returns the product of the terms TERM1 and TERM2,
or NIL when the product is 0. This definition takes care of divisors of 0
in the coefficient ring."
  (let ((c (funcall (ring-mul ring) (term-coeff term1) (term-coeff term2))))
    (unless (funcall (ring-zerop ring) c)
      (make-term (+ (monom-dimension term1) (monom-dimension term2))
		 :initial-exponents (monom-exponents (monom-mul term1 term2))
		 :coeff c))))

(defun term-sugar (term)
  (monom-sugar term))
