(defvar *files* 
  '("utils" "monomial" "ring"
    "order" "term" "termlist" "polynomial" "priority-queue"
    "pair-queue" "grobner-debug" "division" "criterion" "buchberger" "gebauer-moeller"
    "gb-postprocessing" "grobner-wrap" "ideal" "ngrobner-package" "ngrobner")
  "All Lisp files needed. The order of files is important!")

(defun compile-ngrobner ()
  "Compile/load NGROBNER package files without ASDF."
  (dolist (file *files*)
    (compile-file file :verbose t :print t)))

(defun load-ngrobner ()
  "Load NGROBNER package files without ASDF."
  (dolist (file *files*)
    (load file :verbose t :print t)))
