;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "NGROBNER"
  (:use :cl :ring :monomial :order :polynomial :grobner-debug :division :buchberger :gebauer-moeller :gb-postprocessing :ideal :utils)
  (:export 
   "$LEX" "$GRLEX" "$GREVLEX" "$INVLEX" "$RING_OF_INTEGERS"
   "$POLY_ELIMINATION_ORDER" "$POLY_MONOMIAL_ORDER"
   "$POLY_MONOMIAL_ORDER" "$POLY_PRIMARY_ELIMINATION_ORDER"
   "$POLY_PRIMARY_ELIMINATION_ORDER" "$POLY_RETURN_TERM_LIST"
   "$POLY_SECONDARY_ELIMINATION_ORDER" "*EXPRESSION-RING*"
   "*ELIMINATION-ORDER*" "*MONOMIAL-ORDER*"
   "*PRIMARY-ELIMINATION-ORDER*" "*SECONDARY-ELIMINATION-ORDER*"
   "*RATDISREP-FUN*" "BUCHBERGER" "BUCHBERGER-CRITERION"
   "COERCE-COEFF" "COERCE-TO-MAXIMA" "COLON-IDEAL" "ELIMINATION-IDEAL"
   "GROBNER" "FIND-ORDER" "FIND-RING" "$POLY_COEFFICIENT_RING"
   "GROBNER-EQUAL" "GROBNER-MEMBER" "GROBNER-SUBSETP"
   "IDEAL-INTERSECTION" "IDEAL-POLYSATURATION"
   "IDEAL-POLYSATURATION-1" "IDEAL-SATURATION" "IDEAL-SATURATION-1"
   "MAKE-POLY-FROM-TERMLIST" "MAKE-POLY-ZERO" "MAKE-RING" "MAKE-TERM"
   "MAKE-VARIABLE" "MINIMIZATION" "NORMAL-FORM" "POLY-ADD"
   "MONOM-EXPONENTS" "POLY-CONTENT" "POLY-DEPENDS-P"
   "POLY-EXACT-DIVIDE" "POLY-EXPT" "POLY-LCM" "POLY-LM" "POLY-LT"
   "POLY-MUL" "POLY-NORMALIZE" "POLY-NORMALIZE-LIST"
   "POLY-PRIMITIVE-PART" "POLY-PSEUDO-DIVIDE" "POLY-SUB" "POLY-UMINUS"
   "POLY-ZEROP" "POLYSATURATION-EXTENSION" "POLY-TERMLIST"
   "REDUCED-GROBNER" "REDUCTION" "RING-UNIT" "SATURATION-EXTENSION"
   "SPOLY" "$POLY_COEFFICIENT_RING" "$POLY_ELIMINATION_ORDER"
   "TERM-COEFF" "TERM-MONOM" "$POLY_GROBNER_DEBUG" "MAKELIST-1" "MAKELIST"
   "MAKE-MONOM" "LEX>" "GRLEX>" "GREVLEX>" "REVLEX>" "INVLEX>"
   "ELIMINATION-ORDER" "ELIMINATION-ORDER-1"
   "*PRIMARY-ELIMINATION-ORDER*"
   "*SECONDARY-ELIMINATION-ORDER*"
   "*ELIMINATION-ORDER*"
))

(in-package :ngrobner)

(defun compile-ngrobner ()
  "Compile/load NGROBNER package files without ASDF. The order of files is
 important!"
  (dolist (file '("ngrobner-package" "utils" "ngrobner" "monomial"
		  "order" "term" "termlist" "polynomial" "priority-queue"
		  "pair-queue" "division" "criterion" "buchberger" "gebauer-moeller"
		  "gb-postprocessing" "ideal"))
    (compile-file file :verbose t :print t)))

