(in-package "POLYNOMIAL")

(defgeneric static-sugar (object)
  (:documentation "Return statically calculated sugar of object OBJECT. That is,
the sugar value which does not assume that the object is a result of any prior calculations.")
  (:method ((object monom))
    "Static sugar of a monom OBJECT is simply the total degree."
    (total-degree object))
  (:method ((object poly))
    "Static sugar of a poly OBJECT is the maximum sugar of its terms."
  (with-slots (termlist)
	object
      (loop for trm in termlist maximize (sugar trm)))))

(defclass sugar ()
  ((value :initarg :value :initform -1 :accessor sugar-value :type fixnum)))

(defclass monom-with-sugar (monom sugar) ())

(defmethod print-object ((self monom-with-sugar) stream)
  (print-unreadable-object (self stream :type t :identity t)
    (with-accessors ((exponents monom-exponents) (value sugar-value))
	self
      (format stream "EXPONENTS=~A SUGAR=~A"
	      exponents value))))


(defmethod shared-initialize :after ((self monom-with-sugar) slot-names &rest initargs &key)
  "Initialize sugar value based on the exponents."
  (declare (ignore slot-names initargs))
  (setf (slot-value self 'value) (static-sugar self)))

(defclass term-with-sugar (term sugar) ())

(defmethod print-object ((self term-with-sugar) stream)
  (print-unreadable-object (self stream :type t :identity t)
    (with-accessors ((exponents monom-exponents) (value sugar-value) (coeff term-coeff))
	self
      (format stream "EXPONENTS=~A COEFF=~A SUGAR=~A"
	      exponents coeff value))))
