(defun slow-add (p q order-fn add-fn)
  (cond
    ((endp p) q)
    ((endp q) p)
    (t 
     (multiple-value-bind 
	   (greater-p equal-p)
	 (funcall order-fn (car p) (car q))
       (cond
	 (greater-p 			; (> (car p) (car q))
	  (cons (car p) (slow-add (cdr p) q order-fn add-fn))
	  )
	 (equal-p			; (= (car p)) (car q))
	  (let ((s (funcall add-fn (lc p) (lc q))))
	    (cond 
	      ((universal-zerop s)
	       (slow-add (cdr p) (cdr q) order-fn add-fn))
	      (t 
	       ;; Adjust the lc of p
	       (setf (lc p) s)
	       (cons (car p) (slow-add (cdr p) (cdr q) order-fn add-fn))
	       ))))
	 (t		       ;(< (car p) (car q))			
	  (cons (car q) (slow-add p (cdr q) order-fn add-fn))
	  ))))))
