;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Run tests using 5am unit testing framework
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; We assume that QuickLisp package manager is installed.
;; See :
;;      https://www.quicklisp.org/beta/
;;

;; The following is unnecessary after running:
;; * (ql:add-to-init-file)
;; at lisp prompt:
;;(load "~/quicklisp/setup")

(ql:quickload :fiveam)

;; Unless NGROBNER system loaded by ASDF,
;; load the dependencies directly
#-ngrobner
(progn
  (require :utils "utils")
  (require :copy "copy")
  (require :monom "monom")
  (require :polynomial "polynomial")
  (require :infix "infix")
  (require :symbolic-polynomial "symbolic-polynomial")
  (require :division "division")
  (require :priority-queue "priority-queue")
  (require :pair-queue "pair-queue")
  (require :buchberger "buchberger"))

(defpackage #:5am-buchberger
  (:use :cl :it.bese.fiveam :monom :polynomial :infix :symbolic-polynomial :division :priority-queue :buchberger))

(in-package :5am-buchberger)

(def-suite buchberger-suite 
    :description "Buchberger algorithm suite")

(in-suite buchberger-suite)


(test buchberger
  "Buchberger algorithm"
  (let* ((fl (cdr (string->poly "[x+y,x-2*y]" '(x y))))
	 (gb (cdr (string->poly "[x+y,x-2*y,y]" '(x y)))))
    (is-true (grobner-test gb fl))
    (is (every #'universal-equalp (buchberger fl) gb))
    (is (every #'universal-equalp (parallel-buchberger fl) gb))
    )
  )


(run! 'buchberger-suite)
(format t "All tests done!~%")


