;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Run tests using 5am unit testing framework
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; We assume that QuickLisp package manager is installed.
;; See :
;;      https://www.quicklisp.org/beta/
;;

;; The following is unnecessary after running:
;; * (ql:add-to-init-file)
;; at lisp prompt:
;;(load "~/quicklisp/setup")

(ql:quickload :fiveam)

;; Unless NGROBNER system loaded by ASDF,
;; load the dependencies directly
#-ngrobner
(progn
  (require :utils "copy")
  (require :utils "utils")
  (require :monom "monom")
  (require :polynomial "polynomial")
  (require :infix "infix")
  (require :infix "infix-printer")
  (require :symbolic-polynomial "symbolic-polynomial")
  (require :heap "heap")
  (require :priority-queue "priority-queue")
  (require :pair-queue "pair-queue")
  (require :grobner-debug "grobner-debug")
  (require :criterion "criterion")
)

(defpackage #:5am-criterion
  (:use :cl :it.bese.fiveam :monom :polynomial :infix
	:symbolic-polynomial :pair-queue :criterion))

(in-package :5am-criterion)

(def-suite criterion-suite 
    :description "Buchberger criterion suite")

(in-suite criterion-suite)

(def-fixture criterion-1-context () 
  (let ((true-pair (make-instance 'critical-pair 
				   :first (string->poly "x^2+2*y" '(x y z)) 
				   :second (string->poly "y*z + z^2" '(x y z))))
	(false-pair (make-instance 'critical-pair 
				   :first (string->poly "x^2*y+z" '(x y z)) 
				   :second (string->poly "y*z + z^2" '(x y z)))))
    (&body)))

(test criterion-1 
  "First Buchberger criterion"
  (with-fixture criterion-1-context ()
    (is-true (criterion-1 true-pair))
    (is-false (criterion-1 false-pair))))

(def-fixture criterion-2-failure-context () 
  (let* ((p1 (string->poly "x^2+2*y" '(x y z)))
	 (p2 (string->poly "y*z + z^2" '(x y z)))
	 (pair (make-instance 'critical-pair 
				   :first p1 
				   :second p2))
	 (b-done (make-hash-table))	;TODO: make meaningful B-DONE table
	 (partial-basis nil))
    (&body)))

(test criterion-2-failure
  "Second Buchberger criterion failure"
  (with-fixture criterion-2-failure-context ()
    (is-false (criterion-2 pair b-done partial-basis))))

(def-fixture criterion-2-success-context () 
  (let* ((f (string->poly "x^2+2*y" '(x y z)))
	 (g (string->poly "y*z + z^2" '(x y z)))
	 (h (string->poly "x^2*y*z" '(x y z)))
	 (pair (make-instance 'critical-pair :first f :second g))
	 (b-done (make-hash-table :test #'equal)) ;TODO: make meaningful B-DONE table
	 (partial-basis (list h)))
    (setf (gethash (list f h) b-done) t
	  (gethash (list h f) b-done) t
	  (gethash (list h g) b-done) t
	  (gethash (list g h) b-done) t)
    (maphash #'(lambda (key value) 
		 (declare (ignore value)) 
		 (print (mapcar #'->sexp key)))
	     b-done)
    (&body)))

(test criterion-2-success
  "Second Buchberger criterion success"
  (with-fixture criterion-2-success-context ()
    (is-true (criterion-2 pair b-done partial-basis))))


(run! 'criterion-suite)
(format t "All tests done!~%")


