;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "PRIORITY-QUEUE"
  (:use :cl :heap)
  (:export "PRIORITY-QUEUE"
	   "ENQUEUE"
	   "DEQUEUE"
	   "QUEUE-EMPTY-P"
	   "QUEUE-SIZE"
	   )
  (:documentation "Implements a priority queue."))

(in-package :priority-queue)

(defclass priority-queue ()
  ((heap :initarg :heap :reader priority-queue-heap)
   (test :initarg :test :reader priority-queue-test))
  (:documentation "Representa a priority queue."))

(defmethod initialize-instance :after ((self priority-queue) 
				&key 
				  (element-type 'fixnum)
				  (test #'<=)
				  (element-key #'identity))
  (with-accessors ((heap priority-queue-heap) 
		   (test-x priority-queue-test))
      self
    (setf heap (make-heap :element-type element-type)
	  test-x #'(lambda (x y) (funcall test (funcall element-key y) (funcall element-key x))))))
  
(defgeneric enqueue (self item)
  (:method ((self priority-queue) (item t))
    (with-slots (heap test)
	self
      (heap-insert heap item test))
    self))


(defgeneric dequeue (self)
  (:method ((self priority-queue))
    (with-slots (heap test)
	self
      (heap-remove heap test))))

(defgeneric queue-empty-p (self)
  (:method ((self priority-queue))
    (with-slots (heap)
	self
      (heap-empty-p heap))))

(defgeneric queue-size (self)
  (:method ((self priority-queue))
    (with-slots (heap)
	self
    (heap-size heap))))
