;;; -*-  mode: lisp; package: maxima; syntax: common-lisp; base: 10 -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  copyright (c) 1999, 2002, 2009, 2015 marek rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  this program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the gnu general public license as published by	 
;;;  the free software foundation; either version 2 of the license, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  this program is distributed in the hope that it will be useful,		 
;;;  but without any warranty; without even the implied warranty of		 
;;;  merchantability or fitness for a particular purpose.  see the		 
;;;  gnu general public license for more details.				 
;;; 		       								 
;;;  you should have received a copy of the gnu general public license		 
;;;  along with this program; if not, write to the free software 		 
;;;  foundation, inc., 59 temple place - suite 330, boston, ma 02111-1307, usa.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "COPY"
  (:use :cl)
  (:export "COPY-INSTANCE")
  (:shadowing-import-from 
   #+openmcl-native-threads #:ccl 
   #+cmu #:pcl
   #+sbcl #:sb-pcl 
   #+lispworks #:hcl 
   #+allegro #:mop 
   #+clisp #:clos
   #:class-slots #:slot-definition-name)
  (:documentation "Implements generic clone operation."))

(in-package :copy)


;; Source: http://stackoverflow.com/questions/11067899/is-there-a-generic-method-for-cloning-clos-objects
;; NOTE: This is a shallow copy. Add an around method for classes which need deep copy of the slots.
(defgeneric copy-instance (object &rest initargs &key &allow-other-keys)
  (:method ((object cons) &rest initargs &key &allow-other-keys) 
    (declare (ignore initargs))
    (copy-seq object))
  (:documentation "Makes and returns a shallow copy of OBJECT.

  An uninitialized object of the same class as OBJECT is allocated by
  calling ALLOCATE-INSTANCE.  For all slots returned by
  CLASS-SLOTS, the returned object has the
  same slot values and slot-unbound status as OBJECT.

  REINITIALIZE-INSTANCE is called to update the copy with INITARGS.")
  (:method ((object standard-object) &rest initargs &key &allow-other-keys)
    (let* ((class (class-of object))
           (copy (allocate-instance class)))
      (dolist (slot-name (mapcar #'slot-definition-name (class-slots class)))
	(when (slot-boundp object slot-name)
	  (setf (slot-value copy slot-name)
		(slot-value object slot-name))))
      (apply #'reinitialize-instance copy initargs))))

#|
;; A stripped-down version of shallow copy
;; Source: http://stackoverflow.com/questions/11067899/is-there-a-generic-method-for-cloning-clos-objects
(defun shallow-copy-object (original)
  (let* ((class (class-of original))
         (copy (allocate-instance class)))
    (dolist (slot (mapcar #'slot-definition-name (class-slots class)))
      (when (slot-boundp original slot)
        (setf (slot-value copy slot)
              (slot-value original slot))))
    copy))
|#
