;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Run tests using 5am unit testing framework
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; We assume that QuickLisp package manager is installed.
;; See :
;;      https://www.quicklisp.org/beta/
;;

;; The following is unnecessary after running:
;; * (ql:add-to-init-file)
;; at lisp prompt:
;;(load "~/quicklisp/setup")

(ql:quickload :fiveam)

(require :ring "ring")
(require :monom "monom")
(require :monom "term")

(defpackage #:5am-monom
  (:use :cl :it.bese.fiveam :ring :monom :term)
  (:shadowing-import-from :ring "ZEROP" "LCM" "GCD" "+" "-" "*" "/" "EXPT"))

(in-package :5am-monom)

(def-suite monom-suite 
    :description "Monom package suite")

(in-suite monom-suite)

(def-fixture monom-context ()
  (let ((z (make-instance 'monom  :dimension 3))
	(m (make-instance 'monom  :dimension 3 :exponents '(1 2 3)))
	(n (make-instance 'monom  :dimension 3 :exponents '(4 5 6)))
	(m*n (make-instance 'monom  :dimension 3 :exponents '(5 7 9)))
	(n/m (make-instance 'monom  :dimension 3 :exponents '(3 3 3)))
	(m-tensor-n (make-instance 'monom  :exponents '(1 2 3 4 5 6))))
    (&body)))

(test monom-basics
  "Monom basics"
  (with-fixture monom-context () 
    (is (= (r-dimension m) 3))
    (is (= (r-elt m 2) 3))
    (is (= (r-total-degree m) 6))
    (is (= (r-sugar m) 6))
    (is (equalp  (r->list z) '(0 0 0)) "Trivial monomial is a vector of 0's")
    (is (r-equalp (r* m n) m*n))
    (is (r-equalp (r/ n m) n/m))
    (is (r-equalp (r-tensor-product m n) m-tensor-n))
    (signals
	(error "INITIAL-EXPONENTS must have length DIMENSION") 
      (make-instance 'monom  :dimension 3 :exponents '(1 2 3 4 5 6)))
    (is-true (r-divides-p m n))
    (is-false (r-divides-p n m))
    (is (r-equalp (r-gcd m n) m))
    (is (r-equalp (r-lcm m n) n))
    (is-true (r-depends-p m 0))
    (signals
	(error "Index out of bounds")
      (r-depends-p m 3))))
  
(def-fixture term-context ()
  (let ((z (make-instance 'term  :dimension 3))
	(m (make-instance 'term  :dimension 3 :exponents '(1 2 3)))
	(n (make-instance 'term  :dimension 3 :exponents '(4 5 6)))
	(m*n (make-instance 'term  :dimension 3 :exponents '(5 7 9)))
	(n/m (make-instance 'term  :dimension 3 :exponents '(3 3 3)))
	(m-tensor-n (make-instance 'term  :exponents '(1 2 3 4 5 6))))
    (&body)))

(test monom-basics
  "Monom basics"
  (with-fixture term-context () 
    (is (= (r-dimension m) 3))
    (is (= (r-elt m 2) 3))
    (is (= (r-total-degree m) 6))
    (is (= (r-sugar m) 6))
    (is (equalp  (r->list z) '(0 0 0)) "Trivial monomial is a vector of 0's")
    (is (r-equalp (r* m n) m*n))
    (is (r-equalp (r/ n m) n/m))
    (is (r-equalp (r-tensor-product m n) m-tensor-n))
    (signals
	(error "INITIAL-EXPONENTS must have length DIMENSION") 
      (make-instance 'monom  :dimension 3 :exponents '(1 2 3 4 5 6)))
    (is-true (r-divides-p m n))
    (is-false (r-divides-p n m))
    (is (r-equalp (r-gcd m n) m))
    (is (r-equalp (r-lcm m n) n))
    (is-true (r-depends-p m 0))
    (signals
	(error "Index out of bounds")
      (r-depends-p m 3))))



(run! 'monom-suite)
(format t "All tests done!~%")


