;;; -*-  mode: lisp; package: maxima; syntax: common-lisp; base: 10 -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  copyright (c) 1999, 2002, 2009, 2015 marek rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  this program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the gnu general public license as published by	 
;;;  the free software foundation; either version 2 of the license, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  this program is distributed in the hope that it will be useful,		 
;;;  but without any warranty; without even the implied warranty of		 
;;;  merchantability or fitness for a particular purpose.  see the		 
;;;  gnu general public license for more details.				 
;;; 		       								 
;;;  you should have received a copy of the gnu general public license		 
;;;  along with this program; if not, write to the free software 		 
;;;  foundation, inc., 59 temple place - suite 330, boston, ma 02111-1307, usa.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; coefficient ring operations
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; these are all operations that are performed on the coefficients by
;; the package, and thus the coefficient ring can be changed by merely
;; redefining these operations.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "RING"
  (:use :cl)
  (:shadow "GCD" "LCM" "ZEROP" "+" "-" "*" "/" "EXPT")
  (:export "PARSE"
	   "UNIT-FOR"
	   "ZEROP"
	   "+"
	   "-"
	   "*"
	   "+"
	   "/"
	   "EXPT"
	   "LCM"
	   "EZGCD"
	   "GCD"
	   ))

(in-package :ring)

(defgeneric unit-for (object)
  (:method ((self number)) 1))

(defgeneric zerop (object)
  (:method ((self number)) (cl:zerop self)))

(defgeneric + (x y)
  (:method ((x number) (y number)) (cl:+ x y))) 

(defgeneric - (x y)
  (:method ((x number) (y number)) (cl:- x y))) 

(defgeneric * (x y)
  (:method ((x number) (y number)) (cl:* x y))) 

(defgeneric tensor-times (x y))

(defgeneric / (x y)
  (:method ((x number) (y number)) (cl:/ x y))) 

(defgeneric lcm (x y)
  (:method ((x integer) (y integer)) (cl:lcm x y))) 

(defgeneric ezgcd (x y)
  (:method ((x integer) (y integer)
	    &aux (c (cl:gcd x y)))
    (values c (cl:/ x c) (cl:/ y c))))

(defgeneric gcd (x y)
  (:method ((x integer) (y integer))
    (cl:gcd x y)))

(defgeneric dimension (object))

(defgeneric total-degree (object &optional start end))

(defgeneric divides-p (object1 object2)
  (:method ((object1 integer) (object2 integer))
    (cl:zerop (rem object2 object1)))
  (:documentation "Returns T if OBJECT1 divides OBJECT2"))

(defgeneric divides-lcm-p (object1 object2 object3)
  (:documentation "Returns T if OBJECT divides LCM(OBJECT2, OBJECT3), NIL otherwise."))

(defgeneric lcm-divides-lcm-p (object1 object2 object3 object4)
  (:documentation "Returns T if LCM(OBJECT1,OBJECT2) divides LCM(OBJECT3,OBJECT4), NIL otherwise."))

(defgeneric lcm-equal-lcm-p (object1 object2 object3 object4)
  (:documentation "Returns T if object LCM(OBJECT1,OBJECT2) equals LCM(OBJECT3,OBJECT4), NIL otherwise."))
