;;; -*-  mode: lisp; package: maxima; syntax: common-lisp; base: 10 -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  copyright (c) 1999, 2002, 2009, 2015 marek rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  this program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the gnu general public license as published by	 
;;;  the free software foundation; either version 2 of the license, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  this program is distributed in the hope that it will be useful,		 
;;;  but without any warranty; without even the implied warranty of		 
;;;  merchantability or fitness for a particular purpose.  see the		 
;;;  gnu general public license for more details.				 
;;; 		       								 
;;;  you should have received a copy of the gnu general public license		 
;;;  along with this program; if not, write to the free software 		 
;;;  foundation, inc., 59 temple place - suite 330, boston, ma 02111-1307, usa.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; coefficient ring operations
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; these are all operations that are performed on the coefficients by
;; the package, and thus the coefficient ring can be changed by merely
;; redefining these operations.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "RING"
  (:use :cl)
  (:export "RING"
	   "RING-PARSE"
	   "RING-UNIT"
	   "RING-ZEROP"
	   "RING-ADD"
	   "RING-SUB"
	   "RING-UMINUS"
	   "RING-MUL"
	   "RING-DIV"
	   "RING-LCM"
	   "RING-EZGCD"
	   "RING-GCD"
	   "MAKE-RING"
	   "+RING-OF-INTEGERS+"
	   ))

(in-package :ring)

#|

(defstruct (ring)
  "Defines a RING structure, whose fields
are common ring operations necessary to implement
Groebner bases."
  (parse #'identity :type function)
  (unit #'identity :type function)
  (zerop #'identity :type function)
  (add #'identity :type function)
  (sub #'identity :type function)
  (uminus #'identity :type function)
  (mul #'identity :type function)
  (div #'identity :type function)
  (lcm #'identity :type function)
  (ezgcd #'identity :type function)
  (gcd #'identity :type function))

(defparameter +ring-of-integers+
  (make-ring
   :parse #'identity
   :unit #'(lambda () 1)
   :zerop #'zerop
   :add #'+
   :sub #'-
   :uminus #'-
   :mul #'*
   :div #'/
   :lcm #'lcm
   :ezgcd #'(lambda (x y &aux (c (gcd x y))) (values c (/ x c) (/ y c)))
   :gcd #'gcd
   )
  "The ring of integers.")
|#

(defgeneric ring-parse (object)
  (:method ((object t)) object))

(defgeneric ring-unit-for (object)
  (:method ((self integer)) 1))
