;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Create the main Groebner Basis package.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "NGROBNER"
  (:use :cl :ring :monom :order :ring-and-order :term :infix :infix-printer :polynomial :grobner-debug 
	:division :buchberger :gebauer-moeller :gb-postprocessing :ideal
	:utils :grobner-wrap)
  (:export 
   ;;
   ;; Global symbols/switches usable at Maxima interpreter level
   ;;
   "$LEX" "$GRLEX" "$GREVLEX" "$INVLEX" ;names of monomial orders
   "$RING_OF_INTEGERS"			;name of ring of integers
   "$POLY_ELIMINATION_ORDER" "$POLY_MONOMIAL_ORDER" 
   "$POLY_MONOMIAL_ORDER" "$POLY_PRIMARY_ELIMINATION_ORDER"
   "$POLY_PRIMARY_ELIMINATION_ORDER" 
   "$POLY_SECONDARY_ELIMINATION_ORDER" 
   "$POLY_RETURN_TERM_LIST"
   "$POLY_COEFFICIENT_RING"
   "$EXPRESSION_RING"
   "$POLY_GROBNER_DEBUG"		;debugging switch
   ;;
   ;; Global variables
   ;;
   "*EXPRESSION-RING*"
   "*ELIMINATION-ORDER*" 
   "*MONOMIAL-ORDER*"
   "*PRIMARY-ELIMINATION-ORDER*" 
   "*SECONDARY-ELIMINATION-ORDER*"
   "*RATDISREP-FUN*" 
   ;;
   ;; Polynomial ring operations
   ;; Note that some require Groebner basis.
   ;;
   "POLY-ADD" "POLY-SUB" "POLY-UMINUS"
   "POLY-MUL" "POLY-EXPT"
   "POLY-ZEROP" "POLY-LM" "POLY-LT"
   "POLY-PSEUDO-DIVIDE" 
   "POLY-NORMALIZE" "POLY-NORMALIZE-LIST"
   ;;
   ;; High-level Groebner Basis related functions
   ;;
   "FIND-ORDER" "FIND-RING"
   "NORMAL-FORM"
   "POLY-EXACT-DIVIDE"
   "COLON-IDEAL" "ELIMINATION-IDEAL"
   "GROBNER"    
   "REDUCED-GROBNER" 
   "MINIMIZATION"  "REDUCTION"
   "POLY-LCM"
   "GROBNER-EQUAL" "GROBNER-MEMBER" "GROBNER-SUBSETP"
   "RING-INTERSECTION"
   "IDEAL-INTERSECTION" "IDEAL-POLYSATURATION"
   "IDEAL-POLYSATURATION-1" "IDEAL-SATURATION" "IDEAL-SATURATION-1"
   "BUCHBERGER" "PARALLEL-BUCHBERGER" "GEBAUER-MOELLER" "BUCHBERGER-CRITERION"
   ;;
   ;; Low-level functions
   ;; 
   "COERCE-COEFF" "COERCE-TO-INFIX" "MAKE-POLY-FROM-TERMLIST" "MAKE-POLY-ZERO"
   "MAKE-RING" "MAKE-TERM" "MAKE-POLY-VARIABLE" "MAKE-RING-AND-ORDER" 
   "RO-RING" "RO-ORDER" "MONOM-EXPONENTS"
   "POLY-CONTENT" "POLY-DEPENDS-P" "POLY-PRIMITIVE-PART"
   "POLYSATURATION-EXTENSION" "POLY-TERMLIST" "RING-UNIT"
   "SATURATION-EXTENSION" "SPOLY" "$POLY_ELIMINATION_ORDER" "TERM-COEFF"
   "TERM-MONOM" "MAKELIST-1" "MAKELIST" "MAKE-MONOM" "LEX>" "GRLEX>"
   "GREVLEX>" "REVLEX>" "INVLEX>" "ELIMINATION-ORDER"
   "ELIMINATION-ORDER-1" "*PRIMARY-ELIMINATION-ORDER*"
   "*SECONDARY-ELIMINATION-ORDER*" "*ELIMINATION-ORDER*"
   "INFIX-PRINT" "+RING-OF-INTEGERS+"
   ))
