;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "TERM"
  (:use :cl :monomial :ring)
  (:export "TERM"
	   "TERM-EXPONENTS"
	   "TERM-MONOM"
	   "TERM-COEFF"
	   "MAKE-TERM"
	   "MAKE-TERM-VARIABLE"
	   "TERM-MUL"
	   "TERM-SUGAR"))


(in-package :term)

(defstruct (term
	     ;; A simple BOA constructor
	     (:constructor make-term (monom coeff))
	     ;;(:constructor make-term-variable)
	     ;;(:type list)
	     )
  (monom nil :type monom)
  (coeff nil))


(defun make-term-variable (ring nvars pos
				&optional
				(power 1)
				(coeff (funcall (ring-unit ring))))
  "Construct a term in the polynomial ring RING[X[0],X[1],X[2],...X[NVARS-1]]
over the ring RING which represents a single variable. It assumes
number of variables NVARS and the variable is at position
POS. Optionally, the variable may appear raised to power POWER.
Optionally, the term may appear with an arbitrary coefficient, which
defaults to the unit of the RING."
  (make-term (make-monom-variable nvars pos power) coeff))

(defun term-mul (ring term1 term2)
  "Returns the product of the terms TERM1 and TERM2,
or NIL when the product is 0. This definition takes care of divisors of 0
in the coefficient ring."
  (let ((c (funcall (ring-mul ring) (term-coeff term1) (term-coeff term2))))
    (unless (funcall (ring-zerop ring) c)
      (make-term (monom-mul (term-monom term1) (term-monom term2)) c))))

(defun term-sugar (term)
  (monom-sugar (term-monom term)))

(defun term->cons (term) 
  "A transparent representation of a term as (EXPONENTS . COEFF)."
  (cons (monom->list (term-monom term)) (term-coeff term)))

