(in-package "POLYNOMIAL")

(defgeneric static-sugar (object)
  (:documentation "Return statically calculated sugar of object OBJECT. That is,
the sugar value which does not assume that the object is a result of any prior calculations.")
  (:method ((object monom))
    (total-degree object))
  (:method ((object poly))
    (with-slots (termlist)
	object
      (loop for trm in termlist maximize (sugar trm)))))

(defclass sugar ()
  ((value :initarg :value :initform -1 :accessor sugar-value :type fixnum)))

(defclass monom-with-sugar (monom sugar) ())

(defmethod shared-initialize :after ((self monom-with-sugar) slot-names &rest initargs &key)
  "Initialize sugar value based on the exponents"
  (declare (ignore slot-names initargs))
  (setf (slot-value self 'value) (sugar self)))


