(in-package :polynomial)

(proclaim '(special p0 q0 p q p+q-good p+q-risky))

(setf p0 (alist->poly (reverse '(((2 0 0) . 2) ((1 1 0) . 1) ((1 0 0) . 1) ((0 1 0) . -1) ((0 0 0) . 2)))))
(setf q0 (alist->poly (reverse '(((2 0 0) . 2) ((0 1 0) . -1) ((0 0 0) . 2)))))

(setf p (poly-termlist p0))
(setf q (poly-termlist q0))

(setf p+q-good (mapcar #'->list (slow-add (mapcar #'copy:copy-instance p) (mapcar #'copy:copy-instance q) #'lex> #'add-to)))

(setf p+q-risky (mapcar #'->list (fast-and-risky-add (mapcar #'copy:copy-instance p) (mapcar #'copy:copy-instance q) #'lex> #'add-to)))

(assert (equal p+q-good p+q-risky) nil "Two methods gave different results.")
