;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Run tests using 5am unit testing framework
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; We assume that QuickLisp package manager is installed.
;; See :
;;      https://www.quicklisp.org/beta/
;;

;; The following is unnecessary after running:
;; * (ql:add-to-init-file)
;; at lisp prompt:
;;(load "~/quicklisp/setup")

(ql:quickload :fiveam)

(defpackage #:5am-monom
  (:use :cl :it.bese.fiveam :infix-printer)
  (:documentation "Infix printing tests"))

(in-package :5am-monom)

(def-suite infix-printer-suite
    :description "Infix printer suite")

(in-suite infix-printer-suite)

(test operator-precedence 
  "Operator precedence"
  (is (equal (infix-print-to-string '(* (+ a b) c)) "(A+B)*C"))
  (is (equal (infix-print-to-string '(+ (* a b) c)) "A*B+C"))
  (is (equal (infix-print-to-string '(sin x)) "SIN(X)"))
  ;; TODO: Eliminate an extra level of parenthesis in expression below. This
  ;; requires changing condition to parenthesize in INFIX-PRINT. The deeper
  ;; complication is that the INFIX package defines the precedence of
  ;; operators, and it defines token operators. Thus, consistency
  ;; should be ensured so that the printed expression can be read back
  ;; observing the precedence defined in the INFIX package
  (is (equal (infix-print-to-string '(* 3 (sin x))) "3*(SIN(X))"))
  (is (equal (infix-print-to-string '(+ (* 3 x) (- (* 2 (expt y 2)) z))) "3*X+2*(Y^2)-Z"))
  ;; Distinguich between unary and binary minus
  (is (equal (infix-print-to-string '(+ x (- y z))) "X+Y-Z"))
  (is (equal (infix-print-to-string '(+ x (- y))) "X-Y"))
  (is (equal (infix-print-to-string '(- x (- y))) "X+Y"))
  (is (equal (infix-print-to-string '(- x (- y z))) "X-Y+Z"))
  ;; Distinguich between unary and binary division
  (is (equal (infix-print-to-string '(* x (/ y z))) "X*Y/Z"))
  (is (equal (infix-print-to-string '(* x (/ y))) "X/Y"))
  ;; Handling negative numbers
  (is (equal (infix-print-to-string '(+ x -1 2 -3)) "X-1+2-3"))
  (is (equal (infix-print-to-string '(- x (- y 7))) "X-Y+7"))
  )


(run! 'infix-printer-suite)
(format t "All tests done!~%")


