(in-package :polynomial)

;; Getter/setter of leading coefficient
(defun lc (x) (term-coeff (car x)))
(defun (setf lc) (new-value x) (setf (term-coeff (car x)) new-value))

(defun fast-add (p q order-fn add-fn)
  (cond
    ((endp p) p)
    ((endp q) q)
    (t 
     (multiple-value-bind 
	   (greater-p equal-p)
	 (funcall order-fn (car p) (car q))
       (cond
	 (greater-p 			; (> (cadr h) (car q))
	  (cons (car p) (fast-add (cdr p) q order-fn add-fn))
	  )
	 (equal-p			; (= (cadr h)) (car q))
	  (let ((s (funcall add-fn (lc p) (lc q))))
	    (cond 
	      ((universal-zerop s)
	       (fast-add (cdr p) (cdr q) order-fn add-fn))
	      (t 
	       ;; Adjust the lc of p
	       (setf (lc p) s)
	       (cons (car p) (fast-add (cdr p) (cdr q) order-fn add-fn))
	       ))))
	 (t		       ;(< (cadr h) (car q))			
	  (cons (car q) (fast-add p (cdr q) order-fn add-fn))
	  ))))))







	  
