(load "boot")

(use-package :polynomial)
(use-package :monom)

;;(shadow '(fast-add) "POLYNOMIAL")

;; Getter/setter of leading coefficient
(defun lc (x) (term-coeff (car x)))
(defun (setf lc) (new-value x) (setf (term-coeff (car x)) new-value))

(defvar order-fn #'lex>)
(defvar add-fn #'add-to)

(defun fast-add-helper (p q)
  (do ((h p))
      ((endp q) p)
    (multiple-value-bind 
	  (greater-p equal-p)
	(funcall order-fn (car h) (car q))
      (cond
	(greater-p 			; (> (lm h) (lm q))
	 (setf h (cdr h))
	 )
	(equal-p			; (= (lm h) (lm q))
	 (let ((s (funcall add-fn (lc h) (lc q))))
	   (cond 
	     ((universal-zerop s)
	      (cond 
		(setf h (cdr h)
		      q (cdr q))))
	     (t 
	      ;; Adjust the lc of p
	      (setf (lc h) s)
	      (setf h (cdr h)
		       q (cdr q))))))

	(t			 ;(< (lm h) (lm q))			
	 




	  
