;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Run tests using 5am unit testing framework
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; We assume that QuickLisp package manager is installed.
;; See :
;;      https://www.quicklisp.org/beta/
;;

;; The following is unnecessary after running:
;; * (ql:add-to-init-file)
;; at lisp prompt:
;;(load "~/quicklisp/setup")

(ql:quickload :fiveam)

(defpackage #:5am-pair-queue
  (:use :cl :it.bese.fiveam :monom :polynomial :symbolic-polynomial :priority-queue :pair-queue))

(in-package :5am-pair-queue)

(def-suite pair-queue-suite 
    :description "Pair queue package suite")

(in-suite pair-queue-suite)

(def-fixture poly-context () 
  (let* ((p (string->poly "11*x*y*z+13*x^2*y^3*z^4" '(x y z)))
	 (q (string->poly "5*x+7*y*z^2" '(x y z)))
	 (r (string->poly "13*x^2*y+19*z" '(x y z)))
	 (queue (make-critical-pair-queue *normal-strategy* (list p q r))))
    (&body)))

(test queue-building
  "Queue building"
  (with-fixture poly-context ()
    (is (= (queue-size queue) 3))))

(test queue-access
  "Queue access"
  (with-fixture poly-context ()
    (let ((pair (dequeue queue)))
      (is (universal-equalp (critical-pair-first pair) p))
      (is (universal-equalp (critical-pair-second pair) q)))))

;; TODO: Implement more meaningful tests


(run! 'pair-queue-suite)
(format t "All tests done!~%")


