;;; -*- mode: lisp -*-
(in-package :cl-user)

#+sbcl(require :asdf)

(defpackage #:ngrobner-system
  (:use #:asdf #:cl))

(in-package #:ngrobner-system)

(defsystem ngrobner
    :author "Marek Rychlik"
    :licence "LLGPL"
    ;; TODO: Define dependencies for components in a manner
    ;; independent of file order
    :components ((:file "copy")
		 (:file "utils")
		 (:file "ring" :depends-on ("copy"))
		 (:file "rational-field" :depends-on ("ring"))
		 (:file "integer-ring" :depends-on ("rational-field" "ring"))
		 (:file "monom")
		 (:file "polynomial")
                 (:file "polynomial-eval" :depends-on ("polynomial"))
		 (:file "infix")
		 (:file "infix-printer")
                 (:file "symbolic-polynomial")
		 (:file "heap")
		 (:file "grobner-debug")
		 (:file "division")
                 (:file "priority-queue" :depends-on ("heap"))
                 (:file "pair-queue")
		 (:file "criterion")
		 (:file "buchberger")
		 ;;(:file "gebauer-moeller")
		 ;;(:file "gb-postprocessing")
		 ;;(:file "grobner-wrap")
		 ;;(:file "ideal")
		 ;;(:file "ngrobner-package")
		 ;;(:file "ngrobner")
		 )

    :perform     (load-op :after (op ngrobner)
			  (pushnew :ngrobner cl:*features*))

    )
