;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "RATIONAL-FIELD"
  (:use :cl :copy :ring)
  (:export "RATIONAL-FIELD"
	   "RATIONAL-FIELD-VALUE"
	   "ADD-TO"
	   "SUBTRACT-FROM"
	   "MULTIPLY-BY"
	   "DIVIDE-BY"
	   "UNARY-MINUS"
	   "UNARY-INVERSE"
	   "UNIVERSAL-EQUALP"
	   "UNIVERSAL-ZEROP"
	   "->SEXP"
	   "MAKE-ZERO-FOR"
	   "MAKE-UNIT-FOR")
  (:documentation "Wraps rationals into an object."))

(in-package "RATIONAL-FIELD")

(defclass rational-field (ring)
  ((value :initarg :value :initform 0 :accessor rational-field-value :type rational))
  (:documentation "An object representing an integer.")
  )
	   
(defmethod print-object ((self rational-field) stream)
  (print-unreadable-object (self stream :type t :identity t)
    (with-accessors ((value rational-field-value))
	self
      (format stream "VALUE=~A" value))))

(defmethod  multiply-by ((self rational-field) (other rational-field))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
    (setf value (* value other-value))))
  self)

(defmethod divide-by ((self rational-field) (other rational-field))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
      (setf value (/ value other-value))))
  self)

(defmethod  add-to ((self rational-field) (other rational-field))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
    (setf value (+ value other-value))))
  self)

(defmethod  subtract-from ((self rational-field) (other rational-field))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
      (setf value (- value other-value))))
  self)

(defmethod unary-minus ((self rational-field))
  (with-slots (value)
      self
    (setf value (- value)))
  self)

(defmethod unary-inverse ((self rational-field))
  (with-slots (value)
      self
    (setf value (/ value)))
  self)

(defmethod universal-zerop ((self rational-field))
  (with-slots (value)
      self
    (zerop value)))

(defmethod universal-equalp ((self rational-field) (other rational-field))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
      (= value other-value))))

(defmethod ->sexp ((self rational-field) &optional vars)
  (declare (ignore vars))
  (rational-field-value self))

(defparameter *rational-field-zero* (make-instance 'rational-field :value 0))
(defparameter *rational-field-unit* (make-instance 'rational-field :value 1))

(defmethod make-zero-for ((object rational-field))
  ;; NOTE: Always the same object is returned
  *rational-field-zero*)

(defmethod make-unit-for ((object rational-field))
  ;; NOTE: Always the same object is returned
  (make-instance 'rational-field :value 1))
