;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "INTEGER-RING"
  (:use :cl :copy :ring)
  (:export "INTEGER-RING"
	   "INTEGER-RING-VALUE"
	   "ADD-TO"
	   "SUBTRACT-FROM"
	   "MULTIPLY-BY"
	   "DIVIDE-BY"
	   "UNARY-MINUS"
	   "UNIVERSAL-GCD"
	   "UNIVERSAL-EQUALP"
	   "UNIVERSAL-ZEROP"
	   "->SEXP")
  (:documentation "Wraps integers into an object."))

(in-package "INTEGER-RING")

(defclass integer-ring (ring)
  ((value :initarg :value :initform 0 :accessor integer-ring-value))
  (:documentation "An object representing an integer.")
  )
	   
(defmethod print-object ((self integer-ring) stream)
  (print-unreadable-object (self stream :type t :identity t)
    (with-accessors ((value integer-ring-value))
	self
      (format stream "VALUE=~A" value))))

(defmethod  multiply-by ((self integer-ring) (other integer-ring))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
    (setf value (* value other-value))))
  self)

(defmethod  divide-by ((self integer-ring) (other integer-ring))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
      (setf value (/ value other-value))))
  self)

(defmethod  add-to ((self integer-ring) (other integer-ring))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
    (setf value (+ value other-value))))
  self)

(defmethod  subtract-from ((self integer-ring) (other integer-ring))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
      (setf value (- value other-value))))
  self)

(defmethod unary-minus ((self integer-ring))
  (with-slots (value)
      self
    (setf value (- value)))
  self)

(defmethod universal-zerop ((self integer-ring))
  (with-slots (value)
      self
    (zerop value)))

(defmethod universal-gcd ((self integer-ring) (other integer-ring))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
      (setf value (gcd value other-value))))
  self)


(defmethod universal-ezgcd ((object integer-ring) (other integer-ring))
  (with-slots (value)
      object
    (with-slots (other-value)
	other
      (let (c (gcd value other-value))
	(values (make-instance 'integer-ring :value c)
		(make-instance 'integer-ring :value (/ value c))
		(make-instance 'integer-ring :value (/ other-value c)))))))

(defmethod universal-equalp ((self integer-ring) (other integer-ring))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
      (= value other-value))))

(defmethod ->sexp ((self integer-ring) &optional vars)
  (declare (ignore vars))
  (integer-ring-value self))
