;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "RING"
  (:use :cl)
  (:export "RING"
	   "ADD-TO"
	   "SUBTRACT-FROM"
	   "MULTIPLY-BY"
	   "DIVIDE-BY"
	   "UNIVERSAL-EZGCD"
	   "UNIVERSAL-EQUALP"
	   "UNIVERSAL-ZEROP"
	   "->SEXP")
  (:documentation "Defines an abstract ring class and ring operations."))

(in-package "RING")

(defclass ring () () (:documentation "An abstract ring."))
	   
(defgeneric  multiply-by (self other)
  (:documentation "Multiply SELF by OTHER."))

(defgeneric add-to (self other)
  (:documentation "Add OTHER to SELF."))

(defgeneric  subtract-from (self other)
  (:documentation "Subtract OTHER from SELF."))

(defgeneric universal-ezgcd (self other)
  (:documentation "Set SELF value to GCD(SELF, OTHER)"))

(defgeneric universal-equalp (self other)
  (:documentation "Return T if objects SELF and OTHER are equal, NIL otherwise.")
  (:method ((object1 cons) (object2 cons)) (every #'universal-equalp object1 object2)))

(defgeneric universal-zerop (self)
  (:documentation "Return T if SELF is a zero in the ring it belongs to."))

(defgeneric ->sexp (self)
  (:documentation "Convert SELF to an S-expression."))
