;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :ngrobner)


(defun make-term-variable (ring nvars pos
				&optional
				(power 1)
				(coeff (funcall (ring-unit ring)))
				&aux
				(monom (make-monom nvars :initial-element 0)))
  (declare (fixnum nvars pos power))
  (incf (monom-elt monom pos) power)
  (make-term monom coeff))

(defstruct (term
	    (:constructor make-term (monom coeff))
	    ;;(:constructor make-term-variable)
	    ;;(:type list)
	    )
  (monom (make-monom 0) :type monom)
  (coeff nil))

(defun term-sugar (term)
  (monom-sugar (term-monom term)))

(defun termlist-sugar (p &aux (sugar -1))
  (declare (fixnum sugar))
  (dolist (term p sugar)
    (setf sugar (max sugar (term-sugar term)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Additional structure operations on a list of terms
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun termlist-contract (p &optional (k 1))
  "Eliminate first K variables from a polynomial P."
  (mapcar #'(lambda (term) (make-term (monom-contract k (term-monom term))
				      (term-coeff term)))
	  p))

(defun termlist-extend (p &optional (m (make-monom 1 :initial-element 0)))
  "Extend every monomial in a polynomial P by inserting at the
beginning of every monomial the list of powers M."
  (mapcar #'(lambda (term) (make-term (monom-append m (term-monom term))
				      (term-coeff term)))
	  p))

(defun termlist-add-variables (p n)
  "Add N variables to a polynomial P by inserting zero powers
at the beginning of each monomial."
  (declare (fixnum n))
  (mapcar #'(lambda (term)
	      (make-term (monom-append (make-monom n :initial-element 0)
				       (term-monom term))
			 (term-coeff term)))
	  p))

(defun term-mul (ring term1 term2)
  "Returns the product of the terms TERM1 and TERM2,
or NIL when the product is 0. This definition takes care of divisors of 0
in the coefficient ring."
  (let ((c (funcall (ring-mul ring) (term-coeff term1) (term-coeff term2))))
    (unless (funcall (ring-zerop ring) c)
      (make-term (monom-mul (term-monom term1) (term-monom term2)) c))))
