;;; -*- mode: lisp -*-
(in-package :cl-user)

#+sbcl(require :asdf)

(defpackage #:ngrobner-system
  (:use #:asdf #:cl))

(in-package #:ngrobner-system)

(defsystem ngrobner
    :author "Marek Rychlik"
    :licence "LLGPL"
    :components ((:file "copy")
		 (:file "utils")
		 (:file "monom")
                 (:file "polynomial")
		 (:file "infix")
		 (:file "infix-printer")
                 (:file "symbolic-polynomial")
                 (:file "priority-queue")
                 (:file "pair-queue")
		 ;;(:file "grobner-debug")
		 ;;(:file "division")
		 ;;(:file "criterion")
		 ;;(:file "buchberger")
		 ;;(:file "gebauer-moeller")
		 ;;(:file "gb-postprocessing")
		 ;;(:file "grobner-wrap")
		 ;;(:file "ideal")
		 ;;(:file "ngrobner-package")
		 ;;(:file "ngrobner")
		 )

    :perform     (load-op :after (op ngrobner)
			  (pushnew :ngrobner cl:*features*))

    )
