;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Run NGROBNER package tests using 5am unit testing framework
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; We assume that QuickLisp package manager is installed.
;; See :
;;      https://www.quicklisp.org/beta/
;;

;; The following is unnecessary after running:
;; * (ql:add-to-init-file)
;; at lisp prompt:
;;(load "~/quicklisp/setup")

(ql:quickload :fiveam)

(load "ngrobner.asd")
(asdf:load-system :ngrobner)

(defpackage #:utils-tests
  (:use :cl :it.bese.fiveam :ngrobner))

(in-package #:utils-tests)

(def-suite utils-suite 
    :description "Utils Suite")

(in-suite utils-suite)

#+nil
(test dummy-test
  "Makelist"
  (is (= (+ 2 2)) "2 plus 2 wasn't equal to 4 (using #'= to test equality)")
  (is (= 0 (+ -1 1)))
  (signals
      (error "Trying to add 4 to FOO didn't signal an error")
    (+ 'foo 4))
  (is (= 0 (+ 1 1)) "this should have failed"))

(test makelist-1 
  "makelist-1 test"
  (is (equal (ngrobner:makelist-1 (* 2 i) i 0 10) '(0 2 4 6 8 10 12 14 16 18 20)))
  (is (equal (ngrobner:makelist-1 (* 2 i) i 0 10 3) '(0 6 12 18))))

(test makelist
  "makelist"
  (is (equal (ngrobner:makelist (+ (* i i) (* j j)) (i 1 4) (j 1 i)) '(2 5 8 10 13 18 17 20 25 32)))
  (is (equal (ngrobner:makelist (list i j '---> (+ (* i i) (* j j))) (i 1 4) (j 1 i))
	     '((1 1 ---> 2) (2 1 ---> 5) (2 2 ---> 8) (3 1 ---> 10) (3 2 ---> 13)
	       (3 3 ---> 18) (4 1 ---> 17) (4 2 ---> 20) (4 3 ---> 25) (4 4 ---> 32)))))

(test monom
  "monom"
  (is (equalp (ngrobner::make-monom 3) #(0 0 0)) "Trivial monomial is a vector of 0's")
  (is (equalp (ngrobner::make-monom 3 :initial-contents '(1 2 3)) #(1 2 3)) "Monomial with powers 1,2,3"))
  
(run! 'utils-suite)
(format t "All tests done!~%")


