;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Run tests using 5am unit testing framework
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; We assume that QuickLisp package manager is installed.
;; See :
;;      https://www.quicklisp.org/beta/
;;

;; The following is unnecessary after running:
;; * (ql:add-to-init-file)
;; at lisp prompt:
;;(load "~/quicklisp/setup")

(ql:quickload :fiveam)

(require :monom "monom")
(require :term "copy")

(defpackage #:5am-monom
  (:use :cl :it.bese.fiveam :monom :copy)
  (:documentation "Monom and derived classes tests"))

(in-package :5am-monom)

(def-suite monom-suite 
    :description "Monom package suite")

(in-suite monom-suite)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;        MONOM class tests
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(def-fixture monom-context ()
  ;; Use SYMBOL-MACROLET not let to avoid 'unused variable' complaints
  (symbol-macrolet 
      ((m (make-instance 'monom  :exponents '(1 2 3)))
       (n (make-instance 'monom  :exponents '(4 5 6)))
       (m*n (make-instance 'monom  :exponents '(5 7 9)))
       (n/m (make-instance 'monom  :exponents '(3 3 3)))
       (m-tensor-n (make-instance 'monom  :exponents '(1 2 3 4 5 6))))
    (&body)))

(test monom-basics
  "Monom basics"
  (with-fixture monom-context () 
    (is (= (monom-dimension m) 3))
    (is (= (monom-elt m 2) 3))
    (is (= (monom-total-degree m) 6))
    (is (= (monom-sugar m) 6))
    (is (equalp  (monom->list (make-instance 'monom  :dimension 3)) '(0 0 0)) "Trivial monomial is a vector of 0's")
    (is (monom-equalp (monom-multiply-2 m n) m*n))
    (is (monom-equalp (monom-divide-by n m) n/m))
    (is (monom-equalp (monom-right-tensor-product-by m n) m-tensor-n))
    (signals
	(error "EXPONENTS must have length DIMENSION") 
      (make-instance 'monom  :dimension 3 :exponents '(1 2 3 4 5 6)))
    (is-true (monom-divides-p m n))
    (is-false (monom-divides-p n m))
    (is (monom-equalp (monom-gcd m n) m))
    (is (monom-equalp (monom-lcm m n) n))
    (is-true (monom-depends-p m 0))
    (signals
	(error "Index out of bounds")
      (monom-depends-p m 3))
    )
  (with-fixture monom-context ()
    (is (monom-equalp (monom-multiply-by m n) m*n)))
  (with-fixture monom-context ()
    (is (monom-equalp (monom-divide-by n m) n/m)))
  (with-fixture monom-context () 
    (is (equal (monom->list m) '(1 2 3)))))
  
(run! 'monom-suite)
(format t "All tests done!~%")


