;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Run tests using 5am unit testing framework
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; We assume that QuickLisp package manager is installed.
;; See :
;;      https://www.quicklisp.org/beta/
;;

;; The following is unnecessary after running:
;; * (ql:add-to-init-file)
;; at lisp prompt:
;;(load "~/quicklisp/setup")

(ql:quickload :fiveam)

(require :utils "utils")
(require :ring "ring")
(require :monom "monom")
(require :term "term")
(require :order "order")
(require :polynomial "polynomial")
(require :infix "infix")
(require :symbolic-polynomial "symbolic-polynomial")

(defpackage #:5am-symbolic-poly
  (:use :cl :it.bese.fiveam :ring :monom :term :order :polynomial :infix :symbolic-polynomial))

(in-package :5am-symbolic-poly)

(def-suite symbolic-poly-suite 
    :description "Symbolic polynomial package suite")

(in-suite symbolic-poly-suite)

(test read-infix-form
  "Infix form reader"
  (is (equalp (with-input-from-string (s "X^2-Y^2+(-4/3)*U^2*W^3-5") (read-infix-form :stream s))
	      '(+ (- (EXPT X 2) (EXPT Y 2)) (* (- (/ 4 3)) (EXPT U 2) (EXPT W 3)) (- 5))))
  (is (equalp (string->poly "X^2-Y^2+(-4/3)*U^2*W^3-5" '(x y u w))
	      7)))

(def-fixture sym-poly-context ()
  (let ((p (make-instance 'poly))
	(p-symbolic (make-instance 'symbolic-poly :vars '(x))))
    (dolist (x '( ((2) . 22)  ((4) . 44) ((5) . 55) ((8) . 88) ((9) . 99) ))
      (insert-item p (make-instance 'term :exponents (car x) :coeff (cdr x)))
      (insert-item p-symbolic (make-instance 'term :exponents (car x) :coeff (cdr x))))
    (&body)))

(test sym-poly
  "Symbolic polynomial"
  (with-fixture sym-poly-context ()
    (is (r-equalp (change-class p 'symbolic-poly :vars '(x)) p-symbolic )))
  (with-fixture sym-poly-context ()
    (signals
	(error "Number of variables does not equal dimension.")
      (r-equalp (change-class p 'symbolic-poly :vars '(x y)) p-symbolic ))))


(run! 'symbolic-poly-suite)
(format t "All tests done!~%")


