;;; -*- mode: lisp -*-
(in-package :cl-user)

#+sbcl(require :asdf)

(defpackage #:ngrobner-system
  (:use #:asdf #:cl))

(in-package #:ngrobner-system)

(defsystem ngrobner
    :author "Marek Rychlik"
    :licence "LLGPL"
    :components ((:file "ngrobner-package")
		 (:file "utils")
		 (:file "ngrobner")
		 (:file "monomial")
                 (:file "order")
                 (:file "order-mk")
                 (:file "term")
                 (:file "termlist")
                 (:file "polynomial")
                 (:file "priority-queue")
                 (:file "pair-queue")
		 (:file "division")
		 (:file "criterion")
		 (:file "buchberger")
		 (:file "gebauer-moeller")
		 (:file "gb-postprocessing")
		 (:file "ideal")
		 )

    :perform     (load-op :after (op ngrobner)
			  (pushnew :ngrobner cl:*features*))

    )
