;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; NOTE: This file is not a part of the NGROBNER package
;; It defines the Lisp commands to compile and load the package
;; without any sophisticated system definition facility, such as ASDF.
;; Simply, load this file, to compile and load the system.
;; If you want to just compile, comment out the last line: (load-ngrobner)

(defvar *files* 
  '("utils" "monom" "ring"
    "order" "term" "ring-and-order" "termlist" "infix" "infix-printer" "polynomial" "priority-queue"
    "pair-queue" "grobner-debug" "division" "criterion" "buchberger" "gebauer-moeller"
    "gb-postprocessing" "grobner-wrap" "ideal" "ngrobner-package" "ngrobner")
  "All Lisp files needed. The order of files is important!")

(defun compile-ngrobner ()
  "Compile/load NGROBNER package files without ASDF."
  (dolist (file *files*)
    (compile-file file :verbose t :print t)))

(defun load-ngrobner ()
  "Load NGROBNER package files without ASDF."
  (dolist (file *files*)
    (load file :verbose t :print t)))

(compile-ngrobner)
(load-ngrobner)
