;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "TERM"
  (:use :cl :monom :ring)
  (:export "MAKE-TERM-VARIABLE"))

(in-package :term)

(proclaim '(optimize (speed 3) (space 0) (safety 0) (debug 0)))

(defclass term (monom)
  ((coeff :initarg :coeff :accessor r-coeff))
  (:default-initargs :dimension nil :exponents nil :coeff nil))

(defmethod print-object ((self term) stream)
  (format stream "#<TERM DIMENSION=~A EXPONENTS=~A COEFF=~A>"
	  (r-dimension self)
	  (r-exponents self)
	  (r-coeff self)))

(defmethod shared-initialize ((self term) slot-names
			      &rest 
				initargs 
			      &key
				coeff
				&allow-other-keys)
  (declare (ignore initargs))
  (if (eq slot-names t) (setf slot-names '(coeff)))
  (dolist (slot-name slot-names)
    (case slot-name
      (coeff
       (setf (slot-value self 'coeff) coeff)))))

(defmethod update-instance-for-different-class :after ((old monom) 
						       (new term)
						       &key)
  (setf (slot-value new 'coeff) 1))


#|
(defun make-term-variable (nvars pos
			   &optional
			     (power 1)
			     (coeff 1))
  "Construct a term in the polynomial ring RING[X[0],X[1],X[2],...X[NVARS-1]]
over the ring RING which represents a single variable. It assumes
number of variables NVARS and the variable is at position
POS. Optionally, the variable may appear raised to power POWER.
Optionally, the term may appear with an arbitrary coefficient, which
defaults to the unit of the RING."
  (declare (type fixnum nvars pos))
  (make-term :monom (make-monom-variable nvars pos power)
	     :coeff coeff))

|#

(defmethod r* ((term1 term) (term2 term))
  "Returns the product of the terms TERM1 and TERM2,
or NIL when the product is 0. This definition takes care of divisors of 0
in the coefficient ring."
  (let ((result (change-class (call-next-method) 'term)))
    (setf (r-coeff result) (r* (r-coeff term1) (r-coeff term2)))
    result))

#|

(defun term->cons (term) 
  "A human-readable representation of a term as a cons (MONOM . COEFF)."
  (declare (type term term))
  (cons (monom->list (term-monom term)) (term-coeff term)))

|#
