;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 10 -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage "RING-AND-ORDER"
  (:use :cl :ring :order)
  (:export "RING-AND-ORDER"
	   "MAKE-RING-AND-ORDER"
	   "RO-ORDER"
	   "RO-RING"
	   "RO-ORDER"))

(in-package :ring-and-order)

(defstruct (ring-and-order 
	     (:conc-name ro-)
	     (:constructor make-ring-and-order 
			   (&key 
			    (ring *ring-of-integers*)
			    (order #'lex>)
			    (primary-elimination-order   order)
			    (secondary_elimination_order order)
			    (elimination-order-factory
			     (make-elimination-order-factory primary-elimination-order
							     secondary_elimination_order)))))
  (ring  *ring-of-integers* :type ring)
  (order nil :type function)
  (elimination-order-factory nil :type function))


