#|
  *--------------------------------------------------------------------------*
  |  Copyright (C) 2009, Marek Rychlik (e-mail: rychlik@math.arizona.edu)    |
  |    Department of Mathematics, University of Arizona, Tucson, AZ 85721    |
  |                                                                          |
  | Everyone is permitted to copy, distribute and modify the code in this    |
  | directory, as long as this copyright note is preserved verbatim.         |
  *--------------------------------------------------------------------------*
|#
(require :user-manual "../contrib/user_man/user-manual"))

(defvar *cgb-packages*
  '("MAKELIST" "ORDER" "MONOM" "XGCD" "MODULAR" "COEFFICIENT-RING"
    "TERM" "POLY" "MODULAR-POLY" "DIVISION" "PARSE" "PRINTER" "POLY-WITH-SUGAR"
    "GROBNER" "COLORED-POLY" "POLY-GCD" "RAT" "RATPOLY"
    "STRING-GROBNER" "DYNAMICS" "PROVER"
    "INFIX" "CGB-LISP"))

(eval-when (:load-toplevel :compile-toplevel :execute)
  (asdf::operate 'asdf::load-op 'cgb))

;;----------------------------------------------------------------
;; Generate documentation
;;----------------------------------------------------------------
(defun create-cgb-manuals (prefix format)
  (create-manuals (mapcar #'intern *cgb-packages*)
			      :prefix prefix
			      :extension '.lisp
			      :output-format format))

(eval-when (:load-toplevel :compile-toplevel :execute)
  (create-cgb-manuals '../doc/ 'text)
  (create-cgb-manuals '../latex-doc/ 'latex))
