;;; -*-  Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                              
;;;  Copyright (C) 1999, 2002, 2009, 2015 Marek Rychlik <rychlik@u.arizona.edu>		 
;;;  		       								 
;;;  This program is free software; you can redistribute it and/or modify	 
;;;  it under the terms of the GNU General Public License as published by	 
;;;  the Free Software Foundation; either version 2 of the License, or		 
;;;  (at your option) any later version.					 
;;; 		       								 
;;;  This program is distributed in the hope that it will be useful,		 
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of		 
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		 
;;;  GNU General Public License for more details.				 
;;; 		       								 
;;;  You should have received a copy of the GNU General Public License		 
;;;  along with this program; if not, write to the Free Software 		 
;;;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.	 
;;;										 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "RING")

(defclass integer-ring (rational-field)
  ((value :initarg :value :initform 0 :accessor integer-ring-value :type integer))
  (:documentation "An object representing an integer.")
  )
	   
(defmethod print-object ((self integer-ring) stream)
  (print-unreadable-object (self stream :type t :identity t)
    (with-accessors ((value integer-ring-value))
	self
      (format stream "VALUE=~A" value))))

(defmethod shared-initialize :around ((self integer-ring) slot-names 
				      &rest initargs 
				      &key (value nil value-supplied-p))
  "Checks the argument VALUE. Calls error if it is not an integer."
  (declare (ignore  initargs))
  (when value-supplied-p
    (assert (integerp value) nil "When initializing INTEGER-RING, argument VALUE must be an integer, got ~S." value))
  (call-next-method))


(defmethod unary-inverse ((self integer-ring))
  "Invert SELF, possibly changing class to RATIONAL-FIELD."
  (with-slots (value)
      self
    (case value
      (1 self)
      (-1 self)
      (t
       (warn "In UNARY-INVERSE with argument ~S, conversion from INTEGER-RING to RATIONAL-FIELD." self)
       (unary-inverse (change-class self 'rational-field))))))

(defmethod universal-gcd ((self integer-ring) (other integer-ring))
  (with-slots (value)
      self
    (with-slots ((other-value value))
	other
      (make-instance 'integer-ring :value (gcd value other-value)))))

(defmethod universal-ezgcd ((object integer-ring) (other integer-ring))
  (with-slots (value)
      object
    (with-slots ((other-value value))
	other
      (let ((c (gcd value other-value)))
	(values (make-instance 'integer-ring :value c)
		(make-instance 'integer-ring :value (/ value c))
		(make-instance 'integer-ring :value (/ other-value c)))))))
