
;;poly_grobner([x^3-x^2+2,y-2*x^2+1,z-3*x+5],[x,y,z]);
;;[x^3-x^2+2,y-2*x^2+1,z-3*x+5,2*z^2+20*z-9*y+41,(-z^3)-12*z^2-45*z-104]

(in-package :5am-buchberger)
(proclaim '(special fl ref-gb sp sp-rem))

(setf grobner-debug::$poly_grobner_debug nil)

(setf fl (cdr (string->poly "[x^3-x^2+2,y-2*x^2+1,z-3*x+5]" '(x y z)))
      ref-gb (cdr (string->poly "[x^3-x^2+2,y-2*x^2+1,z-3*x+5,2*z^2+20*z-9*y+41,(-z^3)-12*z^2-45*z-104]" '(x y z))))

(format t "~%")
(format t "FL --> ~A~2%" (poly->string (cons :[ fl)))
(format t "REF-GB --> ~A~2%" (poly->string (cons :[ ref-gb)))

(loop for i from 0 below (length fl)
     do
     (loop for j from (1+ i) below (length fl)
	  do
	  (setf sp (s-polynomial (elt fl i) (elt fl j)))
	  (format t "SPOLY(~A,~A) --> ~A~2%" 
		  (poly->string (elt fl i))
		  (poly->string (elt fl j)) 
		  (poly->string sp))
	  (setf sp-rem (normal-form sp fl))
	  (format t "NORMAL-FORM(~A,~A) --> ~A~2%" 
		  (poly->string sp) 
		  (poly->string (cons :[ fl)) 
		  (poly->string sp-rem))
	  )
)


;;(setf gb (buchberger fl))
